/*:
 * @target MZ
 * @plugindesc 名前入力画面でBackspaceキーで1文字削除できるようにするプラグイン v1.0
 * @author YourName
 *
 * @help
 * ツクールMZ用プラグインです。
 * 名前入力画面（Scene_Name）で、
 * キーボードの Backspace キーを使って
 * 1 文字削除できるようにします。
 *
 * それ以外の挙動・レイアウトはデフォルトのままです。
 *
 * 【使い方】
 * 1. このファイルを NameInputBackspaceMZ.js という名前で保存。
 * 2. プラグイン管理から読み込んで ON にしてください。
 *
 * このプラグインは自由に改変・再配布してOKです。
 */

(() => {
    "use strict";

    // ----------------------------------------------------------------------
    // Backspace キーを入力として認識させる
    // ----------------------------------------------------------------------
    // 既存の keyMapper に Backspace(キーコード8) を追加します。
    // Input は keyMapper に登録されたキーのみ e.preventDefault() を行うので、
    // ここに登録することでブラウザの「戻る」動作も防げます。
    Input.keyMapper[8] = "backspace";

    // ----------------------------------------------------------------------
    // Scene_Name で Backspace を処理
    // ----------------------------------------------------------------------
    const _Scene_Name_update = Scene_Name.prototype.update;
    Scene_Name.prototype.update = function() {
        _Scene_Name_update.call(this);

        // 名前入力ウィンドウが存在＆シーンがアクティブなときだけ処理
        if (this._editWindow && this.isActive()) {
            // backspace が押されたら 1 文字削除
            if (Input.isRepeated("backspace")) {
                this._editWindow.back();
            }
        }
    };

})();
